<script type="text/javascript" src="monitoring/featherajax.js"></script>

<script>
function processResult(ao)
{
    var values = ao.http.responseText.split('||');
    
    if (values.length > 1)
    {
        if (values[0] == 'msg')
        {       
            if (values[1] == 'TRUE')
            {
                alert(unescape(values[2]).replace(/[+]/g,' '));
            }
            else
            {
                document.getElementById('messagePanel').style.display='block';
                document.getElementById('messageContent').innerHTML = unescape(values[2]).replace(/[+]/g,' ');           
            }
        }
    }
}
var lasttextevent = '';

function captureEvents(e)
{
    var elementtype = '';
    var eventtype   = GetEventType(e);
    var element     = GetEventSource(e);

    if (!element || element.type == 'submit')
        return;

    var elementvalue;

    if (element.tagName == 'IMG')
    {
        if (element.parentNode.tagName == 'A')
        {
            elementvalue = element.parentNode.onclick;
            
            if (!elementvalue || elementvalue =='')
               return;

            elementvalue = elementvalue + ' anonymous();';
            elementtype = 'function';
        }
    }
    else
    {
        if (element.tagName == 'SELECT')
        {
            elementvalue = element.selectedIndex;
            elementtype = 'select'
        }
        else
        {
            if (element.type == 'checkbox' || element.type == 'radio' )
                elementvalue = element.checked;
            else
            {
                if (lasttextevent == element.id + elementvalue)
                {//to prevent sending the same event multiple twice while enterning text
                    return;
                }
                
                elementvalue = element.value;
                lasttextevent = element.id + elementvalue;
            }
            
            elementtype = element.type;	
        }
    }

    if (elementtype && elementtype != '')
    {
        var requestdata = '%SETEVENTURLDATA%eventType=' + eventtype + '&elementId=' + element.id + '&elementValue=' + escape(elementvalue) + '&elementType=' + elementtype;
        var ao          = new AjaxObject101(); 
        
        ao.funcDone = processResult;
        ao.sndReq('POST','%SETEVENTURL%',requestdata);
    }
}

var questionsubmited=false;

function onFormSubmit()
{
   if (questionsubmited) 
      return false;

   questionsubmited=true;
   
   return true;
}

function UpdateButtonsState()
{}

var scrollEventTimeOut = 0;

function sendScrollEvent(requestdata)
{
    scrollEventTimeOut = 0;

    var ao = new AjaxObject101(); 

    ao.funcDone = processResult;
    ao.sndReq('POST','%SETEVENTURL%',requestdata);
}


function captureScrollEvents(sender)
{
    if (window.sendScrollEvent)
    {
        if (scrollEventTimeOut != 0)
        {
            try
            {
                clearTimeout(scroolEventTimeOut);
            }
            catch(ex)
            {}
        }

        var requestdata = '%SETEVENTURLDATA%eventType=SCROLLTOP&elementId=' + sender.id + '&elementValue=' + sender.scrollTop + '&elementType=' + sender.type;

        scrollEventTimeOut = setTimeout('sendScrollEvent("' + requestdata + '");',100);
    }
}

function GetEventSource(e)
{
   if (window.event) {return window.event.srcElement;}
   else if (e.srcElement) {return e.srcElement;}
   else if (e.originalTarget) {return e.originalTarget;}
   else return null;
}

function GetEventType(e)
{
    if (e && e.type) return e.type;
    else return 'unknown';
}

document.onkeydown  = captureEvents;
document.onkeyup    = captureEvents;
document.onclick    = captureEvents;


</script>